uniform sampler2D 	waves;
varying vec2 		texcoord;
varying vec2 		texcoord2;
varying vec2 		texcoord3;
varying vec2 		texcoord4;
uniform vec3		sundir;
varying vec3		vdir;
uniform vec3  		SUN; 	// = colore del sole
uniform float 		sunpower;
uniform sampler2D 	bg,
					depthBG,
					reflBG;
varying vec4		pos;
//varying vec4		eyepos;
//varying float 		h;

uniform vec3		horizonColor;
uniform vec3		zenithColor;
uniform vec3 		fogColor; 
uniform vec3		ambientColor;
uniform vec3		waterColor;

uniform float 		inScatter;
uniform float       extintion;
uniform vec3		campos;

uniform float		fogMultiplier;
uniform float		reflMul;
uniform float		specPow;
uniform float		fresnelPow;
uniform float		specMul;

uniform float		density;
uniform float		refrbump;
uniform float		reflbump;

// costanti passate allo shader
uniform vec3  cBr; 	// = RayLeigh
uniform vec3  cBm; 	// = Mie	
uniform	vec3  C0; 	// = cBr+cBm;	
uniform vec3  C1; 	// = 1.0/(cBr+cBm);
uniform float C2;	// = log(e)
uniform float C4;	// = (1-g)^2
uniform float C5;	// = 1+g^2
uniform float C6;	// = 2*g
uniform float C7;	// = 3/2

uniform float cHeightFallof;//=0.0005;
float cVolFogHeightDensityAtViewer=exp( cHeightFallof * -campos.y);

float ComputeVolumetricFog( vec3 cameraToWorldPos )
{
	float fogInt = length( cameraToWorldPos )* cVolFogHeightDensityAtViewer;
	
	if( abs( cameraToWorldPos.y) > 0.01)
	{
		float t = cHeightFallof * cameraToWorldPos.y;
		fogInt*= ( 1.0-exp( -t ) ) / t;
		
	}
	return exp( -extintion/*0.001*/ * fogInt);
}

////////////////////////////
void main()
{
	float internalfoam;
	vec4 wavesNormal=texture2D(waves,texcoord.st);
	vec3 normal=normalize((wavesNormal.xyz*2.0-1.0)+vec3(0.0,0.0,refrbump));
	
	wavesNormal=texture2D(waves,texcoord2.st);
	vec3 normal2=normalize((wavesNormal.xyz*2.0-1.0)+vec3(0.0,0.0,refrbump));

	wavesNormal=texture2D(waves,texcoord3.st);
	vec3 normal3=normalize((wavesNormal.xyz*2.0-1.0)+vec3(0.0,0.0,refrbump));
	
	vec3 N=normal;
	N.y=normal.z;
	N.z=-normal.x;
	N.x=-normal.y;
	
	vec3 N2=normal2;
	N2.y=normal2.z;
	N2.z=-normal2.x;
	N2.x=-normal2.y;
	
	vec3 N3=normal3;
	N3.y=normal3.z;
	N3.z=-normal3.x;
	N3.x=-normal3.y;
	
	N=normalize(N+N2+N3);
	// invert against Y axis
	N.y=-N.y;
	
	//float distance=length(vdir.xyz);
	//float fogdist=clamp(ComputeVolumetricFog(-vdir),0.0,1.0);
	
	vec3 tvdir=normalize(vdir);
	float cos=dot(sundir,tvdir.xyz);
	
	/*float F1=(1.0 + cos*cos);
	float F2=(C4/pow(C5-C6*cos,C7));

	vec3 Br = cBr*F1;
	vec3 Bm = cBm*F2;*/

	// PROVA SCATTERING DIFFUSO ////////////
	//float NdotL=clamp(dot(sundir,N),0.0,1.0);
	/*float NLwrap=(dot(sundir,N)+0.5)/1.5;
	float NdotL = max(NLwrap,0.0);*/
	//float fScatter = smoothstep(0.0, 0.5, NLwrap) * smoothstep(1.0, 0.5,NLwrap);
	//finalcolor *= ((scatter*vec4(0.15, 0.0, 0.0, 1.0))+diffuse); 
				
/*	vec3 halfv = sundir+tvdir;
	halfv=normalize(halfv);
	float spec = clamp(dot(halfv,N),0.0,1.0);
	spec = pow(spec,specPow)*specMul;*/
	
	vec2 UV=(pos.xy/pos.w)*0.5+0.5;
	vec2 reflectOffset=UV+normal.xy*reflbump;
	
	float depth=texture2D(depthBG,UV).z;
	UV+=normal.xy*reflbump;
	
	/*float d=-abs(depth-eyepos.z);
	float d2=exp(d*0.01);
	d=exp(d*density);
	float dist=1.0-(clamp(d,0.0,1.0));
	float fdist=1.0-(clamp(d2,0.0,1.0));
	*/
	float fresnelres=min(pow(1.0-abs(dot(N,tvdir)),fresnelPow/*5.0*/)*5.0,1.0);
	vec3 reflcolor=texture2D(reflBG,reflectOffset).xyz;
	
	////////////////////////////////
	///////////////////////////// FOG ////////////////////////////////
	/*vec3 LinMul;
	LinMul=C1*(1.0-exp(-C0*10000.0*(1.0-fogdist)));
	vec3 fogLin = (Br+Bm*0.1)*LinMul;
	vec3 scatterFogColor=fogLin*inScatter + fogColor*fogMultiplier;*/
	//////////////////////////////////
	
	gl_FragColor.xyz=max(mix(texture2D(bg,UV/*0.25*/).rgb , reflcolor/*reflMul*0.85*/, fresnelres),0.0);// + spec*SUN;
	gl_FragColor.w=1.0;
}
